/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIAnalogSettings {
    private static JDialog dialog;

    public void configChanged() {
    }

    public final void openSettingsEditor(Window window, CfgItemKeymapping cfgItemKeymapping) {
        if (dialog != null) {
            dialog.requestFocus();
            return;
        }
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Mouse Settings", false);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        final JButton jButton = new JButton(" O K ");
        jPanel.add((Component)jButton, "East");
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog = null;
                jDialog.dispose();
            }
        });
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jButton.doClick(0);
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                UIAnalogSettings.this.configChanged();
            }
        };
        JComponent jComponent = UIAnalogSettings.buildControlsPane(cfgItemKeymapping.analogMouseSensitivity, changeListener);
        JComponent jComponent2 = UIAnalogSettings.buildCommentsPane();
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)jComponent2, "North");
        jPanel2.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(Borders.EMPTY_10);
        jDialog.getContentPane().add(jPanel2);
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(false);
        dialog = jDialog;
        jDialog.setVisible(true);
    }

    public static final JComponent buildControlsPane(final CfgItemSensitivity cfgItemSensitivity, final ChangeListener changeListener) {
        final JSlider jSlider = new JSlider(5, 500, (int)(100.0f * cfgItemSensitivity.axisX));
        final JSlider jSlider2 = new JSlider(5, 500, (int)(100.0f * cfgItemSensitivity.axisY));
        final JSpinnerFix jSpinnerFix = new JSpinnerFix(new SpinnerNumberModel(cfgItemSensitivity.axisX, (double)jSlider.getMinimum() / 100.0, (double)jSlider.getMaximum() / 100.0, 0.05));
        final JSpinnerFix jSpinnerFix2 = new JSpinnerFix(new SpinnerNumberModel(cfgItemSensitivity.axisY, (double)jSlider2.getMinimum() / 100.0, (double)jSlider2.getMaximum() / 100.0, 0.05));
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(Borders.BEVEL_LOW_10);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix.setValue((double)new Integer(jSlider.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix.getValue()).floatValue();
                jSlider.setValue((int)(f * 100.0f));
                if (cfgItemSensitivity.axisX != f) {
                    if (changeListener != null) {
                        changeListener.stateChanged(null);
                    }
                    cfgItemSensitivity.axisX = f;
                }
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix2.setValue((double)new Integer(jSlider2.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix2.getValue()).floatValue();
                jSlider2.setValue((int)(f * 100.0f));
                if (cfgItemSensitivity.axisY != f) {
                    if (changeListener != null) {
                        changeListener.stateChanged(null);
                    }
                    cfgItemSensitivity.axisY = f;
                }
            }
        });
        jPanel.add(new JLabel("X axis sensitivity :"));
        jPanel.add(jSlider);
        jPanel.add(jSpinnerFix);
        jPanel.add(new JLabel("Y axis sensitivity :"));
        jPanel.add(jSlider2);
        jPanel.add(jSpinnerFix2);
        UIUtils.makeCompactGrid(jPanel, 2, 3, 0, 0, 6, 4);
        return jPanel;
    }

    public static final JComponent buildCommentsPane() {
        String string = "<html><b>To activate the analog mode for Joystick #1, double-click the game<br>area with the Left mouse button (or use the Right mouse button for<br>Joystick #2).</b><br><br>When in analog mode, click the Middle mouse button to reset both axis, or any<br>other mouse button to return to digital mode.</html>";
        return UIUtils.buildCommentsLabel("How to use the mouse as an analog joystick...", string, false, false);
    }
}

